//
//  TransactionEnums.swift
//  SampleApp
//
//  Created by Apple on 12/09/19.
//  Copyright © 2019 None. All rights reserved.
//
enum TransactionOption: Int, CustomStringConvertible{
    case Transactions
    case ACHTransaction
    case CreditCardTransaction
    case GenericTransaction
    case RouterAccountVaults
    case RouterTransaction
    case EMVTransaction
    
    var description: String{
        switch self {
        case .Transactions: return "Transactions"
        case .RouterTransaction: return "Router Transaction"
        case .CreditCardTransaction: return "Credit Card Transaction"
        case .ACHTransaction: return "ACH Transaction"
        case .GenericTransaction: return "Generic Transaction"
        case .RouterAccountVaults: return "Router Account Vaults"
        case .EMVTransaction: return "EMV Transaction"
        }
    }
}

enum EMVDevices: String {
    case VP3300 = "Vivo VP3300"
    case VP8800 = "Vivo VP8800"
}

enum TransactionActionType: String{
    case Sale = "Sale"
    case Refund = "Refund"
    case AVSOnly = "AVS Only"
    case AuthOnly = "Auth Only"
    case AuthIncrement = "Auth Increament"
    case AuthComplete = "Auth Complete"
    case Store = "Store"
    case Force = "Force"
    case Debit = "Debit"
    case Credit = "Credit"
    case Void = "Void"
    case Edit = "Edit"
    case TipAdjust = "Tip Adjust"
    case BinInfo = "Bin Info"
    case ViewRecord = "Get Transaction"
    case ViewRecordList = "Get Transactions"
    
    var value: String{
        switch self {
        case .Sale: return "sale"
        case .Refund: return "refund"
        case .Void: return"void"
        case .AuthOnly: return "authonly"
        case .AuthComplete:  return"authcomplete"
        case .AuthIncrement: return "authincrement"
        case .Force: return"force"
        case .TipAdjust: return "tipadjust"
        case .Debit: return "debit"
        case .Credit: return "credit"
        case .Edit: return "edit"
        case .AVSOnly: return "avsonly"
        case .ViewRecord: return "viewrecord"
        case .ViewRecordList: return "viewrecordlist"
        case .BinInfo: return "getbininfo"
        case .Store: return "store"
        }
    }
}

let transactionInputs = ["Account Holder Name","Account Number","Account Type","Account Vault API Id","Account Vault Id","ACH Identifier","ACH Sec Code","Additional Amounts[Type]","Additional Amounts[Amount]","Advance Deposit","Auth Amount","Auth Code","AVS","AVS Enhanced","Batch","Billing City","Billing Phone","Billing State","Billing Street","Billing Zip","Card Present","CAVV","Charge Back Date","Check Number","Checkin Date","Checkout Date","Clerk Number","Contact API Id","Contact Id","Created Ts","Custom Data","Customer Id","Customer Ip","CVV","CVV Response","Description","DL Number","DL State","DOB Year","E Format","E Track Data","E Serial Number","Effective Date","EMV Receipt Data","Entry Mode Id","Exp Date","First Six","Id","Image Front","Image Back","Is Recurring","Last Four","Location API Id","Location Id","Modified TS","Move Account Vault","Move Account Vault Transactions","No Show","Notification Email Address","Notification Email Sent","Order Num","Payment Method","PO Number","Previous Transaction Id","Product Transaction Id","Quick Invoice Id","Reason Code Id","Recurring Id","Response Message","Return Date","Room Num","Room Rate","Routing","Save Account","Save Account Title","Settle Date","SSN4","Status Id","SubTotal Amount","Surcharge Amount","Tags","Tax","Terminal Id","Terminal Serial Number","Terms Agree","ThreeDSecure","ThreeDSecure Validated","Ticket","Tip Amount","Track Data","Transaction Amount","Transaction API Id","Transaction C1","Transaction C2","Transaction C3","Transaction C4","Transaction Settlement Status","Type Id","Wallet Id","Verbiage","Void Date","Ticket Id","XID"]
